#include <Wire.h> 
#include <LiquidCrystal_I2C.h>
#define sensorPin 0    // Connexion de la sortie du LM35
#define DELAY1 10      // Bref temps d'attente lors de la mesure
#define DELAY2 500     // Bref temps d'attente lors de l'affichage
#define motorPin 9     // Broche de commande du ventilateur
#define threshold 25   // Température de commutation du ventilateur (25 degrés Celsius)
#define hysterese 0.5  // Valeur d'hystérésis (0,5 degré Celsius)
const int cycles = 20; // Nombre de mesures
LiquidCrystal_I2C lcd(0x27, 2, 1, 0, 4, 5, 6, 7, 3, POSITIVE); // Adresse I2C sur 0x27

void setup() {                
  pinMode(motorPin, OUTPUT);
  lcd.begin(20,4); // Initialisation du LCD
  lcd.backlight(); // Activation du rétroéclairage
}

void loop() {
  float resultTemp = 0.0;
  for(int i = 0; i < cycles; i++) {
    int analogValue = analogRead(sensorPin);
    float temperature = (5.0 * 100.0 * analogValue) / 1024;
    resultTemp += temperature; // Addition des valeurs mesurées
    delay(DELAY1);
  }
  resultTemp /= cycles;       // Calcul de la moyenne
  lcd.clear();                // Effacerl'écran
  lcd.setCursor(0,0);         // Positionnement du curseur sur 1ère ligne
  lcd.print("**Commande ventilo**");
  lcd.setCursor(0,1);         // Positionnement du curseur sur 2ème ligne
  lcd.print("Temperature: ");
  lcd.print(resultTemp);
  lcd.write(0xD0 + 15);       // Caractère degré (Arduino 1.0)
  lcd.print("C");
  lcd.setCursor(0,2);         // Positionnement du curseur sur 3ème ligne
  lcd.print("Moteur: ");
  if(resultTemp > (threshold + hysterese))
    digitalWrite(motorPin, HIGH);
  else if(resultTemp < (threshold - hysterese))
    digitalWrite(motorPin, LOW);
  lcd.print(digitalRead(motorPin) == HIGH?"en marche":"stop");
  delay(DELAY2);
}

